/*------------------------------------------------------------------------------*
 * File Name: MatImportDlgBase.h		 										*
 * Creation: Soapy																*
 * Purpose: Base MatImport Dialog class											*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 *------------------------------------------------------------------------------*/

#ifndef _MATIMPORTDLGBASE_H
#define _MATIMPORTDLGBASE_H


#include "MATVarList.h"		// MATVarList class

#define DEBUG_RETURN		//return TRUE;
//#define _DBINT(_STR, _INT)	//out_int(_STR, _INT);
//#define _DBSTR(_STR)		//out_str(_STR);

#define MATLAB_WKS_NAME	"Matlab"

class MatImportDlgBase : public ResizeDialog
{
public:
	MatImportDlgBase() : ResizeDialog(IDD_MATLAB_IMPORT, "ODlg")
	{
		
	}

protected:
	BOOL OnClose();
	
	// Enable the ImportAsWorksheet Button
	void EnableImportWksBtn(bool bEnable = true);
	
	// Enable the ImportAsMatrix Button
	void EnableImportMatBtn(bool bEnable = true);
	
	// Initialize the MatlabImport Dialog
	BOOL OnInitDialog();
	
	BOOL OnDestroy(void);
	
	// ON resize the dialog	
	BOOL OnDlgResize(int nType, int cx, int cy);
	
		
	BOOL OnClickReplaceMat(Control ctrl);

	BOOL OnClickReplaceCol(Control ctrl);

	
	// Copy from MatlabImport.h -- get / create the associated MatrixLayer
	bool get_Origin_matrix(string strMatName, MatrixLayer& mLayer);


	int check_add_wks_col(Worksheet& wks, string strColName, int nSuffix);

	
	// Import array from a matrix to the worksheet
	int MatToWks(matrix& mat, Worksheet& wks, string strName);

	
protected:
	string 	m_strMatlabWorkspaceFilename;  // the full name of the MAT file
	
	bool	m_bDisableImportBtnUpdate;
	
	MATVarList m_vsFlex;
	
	Button m_btnImportWks;
	Button m_btnImport;
	
	bool m_bUpdateMatrix;
	bool m_bUpdateCols;
};


///DVT - IDOK in error is in dialog resource instead of IDCANCEL - change
BOOL MatImportDlgBase::OnClose()
{
	return TRUE;
}

// Enable the ImportAsWorksheet Button
void MatImportDlgBase::EnableImportWksBtn(bool bEnable )
{
	m_btnImportWks.Enable = bEnable;
}	

// Enable the ImportAsMatrix Button
void MatImportDlgBase::EnableImportMatBtn(bool bEnable )
{
	m_btnImport.Enable = bEnable;
}	

// Initialize the MatlabImport Dialog
BOOL MatImportDlgBase::OnInitDialog()
{
	DEBUG_RETURN
	
	ResizeDialog::OnInitDialog();		
	
	m_bDisableImportBtnUpdate = true;		
	
	// The Variable List
	m_vsFlex.Init(IDC_MATLAB_GRID, *this); 	
	m_vsFlex.ShowTheGrid(FALSE); // hide the grid until attach to MATLAB		
	// ImportAsMatrix Button
	m_btnImport = GetItem(IDC_MATLAB_BTN_IMPORT);
	EnableImportMatBtn(false);
	
	// ImportAsWorksheet Button
	m_btnImportWks = GetItem(IDC_MATLAB_BTN_IMPORT_WKS);
	EnableImportWksBtn(false);				
	// The two check boxes
	Control ctrlReplaceMat = GetItem(IDC_MATLAB_CHK_REPLACE_MAT);
	Control ctrlReplaceWks = GetItem(IDC_MATLAB_CHK_REPLACE_WKS);
	ctrlReplaceMat.Value = 1;
	ctrlReplaceWks.Value = 1;
	m_bUpdateMatrix = true;
	m_bUpdateCols = true;
	
	return TRUE;
}	
	
BOOL MatImportDlgBase::OnDestroy(void)
{
	DEBUG_RETURN

	return TRUE;
}
	
// ON resize the dialog	
BOOL MatImportDlgBase::OnDlgResize(int nType, int cx, int cy)
{
	DEBUG_RETURN
		
	uint nCntrlsRight[] = {
			IDC_MATLAB_BTN_IMPORT,
			IDC_MATLAB_CHK_REPLACE_MAT,
			IDC_MATLAB_BTN_IMPORT_WKS,
			IDC_MATLAB_CHK_REPLACE_WKS,
			IDC_MATLAB_BTN_IMPORT_UPDATE,
			IDOK,
			0};
			
	uint nCntrlsBottom[] = {0};
			
	ResizeMoveControlsRightBottom(IDC_MATLAB_GRID, nCntrlsRight, nCntrlsBottom, cx, cy);
		
	return TRUE;
}


BOOL MatImportDlgBase::OnClickReplaceMat(Control ctrl)
{
	m_bUpdateMatrix = !m_bUpdateMatrix;
	
	return TRUE;
}

BOOL MatImportDlgBase::OnClickReplaceCol(Control ctrl)
{
	m_bUpdateCols = !m_bUpdateCols;
	
	return TRUE;
}
	
// Copy from MatlabImport.h -- get / create the associated MatrixLayer
bool MatImportDlgBase::get_Origin_matrix(string strMatName, MatrixLayer& mLayer)
{
	MatrixLayer mltemp(strMatName);
	if(!mltemp || (!m_bUpdateMatrix && mltemp))
	{
	if(mltemp) // already existed
			mltemp.Detach();
			
		mltemp.Create();
		mltemp.GetPage().Rename(strMatName);
		mLayer = mltemp;
	return true;
	}
	mLayer = mltemp;
	return false;
}

int MatImportDlgBase::check_add_wks_col(Worksheet& wks, string strColName, int nSuffix)
{
	if(nSuffix > 0)
		strColName += nSuffix;
			
	if(m_bUpdateCols)
	{
		Column cc = wks.Columns(strColName);
		if(cc)
			return cc.GetIndex();
	}
		
	return wks.AddCol(strColName);
}
	
// Import array from a matrix to the worksheet
int MatImportDlgBase::MatToWks(matrix& mat, Worksheet& wks, string strName)
{
	uint nRows = mat.GetNumRows();
	uint nCols = mat.GetNumCols();
	
	int nAdded = 0;
	int nNewCol = check_add_wks_col(wks, strName, nAdded);

	if(nCols == 1)
	{
		Dataset aa(wks, nNewCol);
		mat.GetColumn(aa, nAdded++);
	}
	else if (nRows == 1)
	{
		Dataset aa(wks, nNewCol);
		mat.GetRow(aa, nAdded++);
	}
	else
	{			
		do
		{
			Dataset aa(wks, nNewCol);
			mat.GetColumn(aa, nAdded);
			nAdded++;
			if(nAdded >= nCols)
				break;
			nNewCol = check_add_wks_col(wks, strName, nAdded);
		} while(1);
	}
		
	return nAdded;
}		


#endif //_MATIMPORTDLGBASE_H